from django.contrib import admin
from django.urls import path, include
from django.shortcuts import redirect
from django.conf import settings
from django.conf.urls.static import static

from users import views
from users import views_auth
from users import views_profile
from users import views_subscription

urlpatterns = [
    path('admin/', admin.site.urls),
    
    # Allauth URLs (Google OAuth)
    path('accounts/', include('allauth.urls')),

    # Main routes
    path('', views.index, name='home'),
    path('dashboard/', views.dashboard_view, name='dashboard'),

    # Auth routes
    path('signup/', views.signup_view, name='signup'),
    path('login/', views.login_view, name='login'),
    path('signin/', views.login_view, name='signin'),
    path('logout/', views.logout_view, name='logout'),

    # Password Reset
    path('forgot-password/', views_auth.forgot_password_view, name='forgot-password'),
    path('reset-password/<uuid:token>/', views_auth.reset_password_view, name='reset-password'),

    # Email Verification (Disabled)
    path('verify-email/<uuid:token>/', views_auth.verify_email_view, name='verify-email'),

    # Profile & Settings
    path('profile/', views_profile.profile_view, name='profile'),
    path('settings/', views_profile.security_settings_view, name='settings'),
    path('settings/security/', views_profile.security_settings_view, name='security-settings'),

    # Subscription routes
    path('subscription/', views_subscription.subscription_page, name='subscription'),
    path('subscription/checkout/', views_subscription.create_checkout_session, name='subscription-checkout'),
    path('subscription/success/', views_subscription.subscription_success, name='subscription-success'),
    path('subscription/cancel/<int:subscription_id>/', views_subscription.cancel_subscription, name='cancel-subscription'),
    path('subscription/webhook/', views_subscription.stripe_webhook, name='stripe-webhook'),

    # Notifications
    path('notifications/', views_profile.notifications_view, name='notifications'),
    path('notifications/mark-read/<int:notification_id>/', 
         views_profile.mark_notification_read, name='mark-notification-read'),
    path('notifications/mark-all-read/', 
         views_profile.mark_all_notifications_read, name='mark-all-notifications-read'),
    path('notifications/preferences/', 
         views_profile.update_notification_preferences, name='notification-preferences'),

    # Other
    path('term/', views.term_view, name='term'),
]

# Serve media files in development
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
