#!/bin/bash

# Django Deployment Script for cPanel
echo "Starting Django deployment..."

# Variables - UPDATE THESE WITH YOUR DETAILS
DOMAIN="your-domain.com"  # Replace with your actual domain
PROJECT_DIR="/home/$(whoami)/public_html"  # Update if your project path is different
PYTHON_VERSION="python3.9"  # Update with your Python version

echo "Deploying to domain: $DOMAIN"
echo "Project directory: $PROJECT_DIR"

# 1. Navigate to project directory
cd $PROJECT_DIR

# 2. Create virtual environment if it doesn't exist
if [ ! -d "venv" ]; then
    echo "Creating virtual environment..."
    $PYTHON_VERSION -m venv venv
fi

# 3. Activate virtual environment
echo "Activating virtual environment..."
source venv/bin/activate

# 4. Install/update dependencies
echo "Installing dependencies..."
pip install --upgrade pip
pip install -r requirements.txt

# 5. Set environment variables
echo "Setting up environment variables..."
export DJANGO_SETTINGS_MODULE=conn_prjct.settings_production

# 6. Run Django migrations
echo "Running database migrations..."
python manage.py migrate

# 7. Collect static files
echo "Collecting static files..."
python manage.py collectstatic --noinput

# 8. Create superuser (optional - uncomment if needed)
# echo "Creating superuser..."
# python manage.py createsuperuser

# 9. Set proper permissions
echo "Setting file permissions..."
chmod -R 755 .
chmod 644 db.sqlite3

echo "Deployment completed successfully!"
echo "Your Django app should now be accessible at: http://$DOMAIN"