from django.core.management.base import BaseCommand
from users.models import SubscriptionPlan


class Command(BaseCommand):
    help = 'Create default subscription plans'

    def handle(self, *args, **options):
        # Create Practitioner plan
        practitioner_plan, created = SubscriptionPlan.objects.get_or_create(
            plan_type='practitioner',
            defaults={
                'name': 'Practitioner Yearly Plan',
                'price': 997.00,
                'duration_days': 365,
                'description': 'Full access to all practitioner features including patient management, advanced analytics, and priority support.',
                'is_active': True,
            }
        )
        
        if created:
            self.stdout.write(self.style.SUCCESS(f'✓ Created: {practitioner_plan.name}'))
        else:
            self.stdout.write(self.style.WARNING(f'Already exists: {practitioner_plan.name}'))
        
        # Create Patient plan
        patient_plan, created = SubscriptionPlan.objects.get_or_create(
            plan_type='patient',
            defaults={
                'name': 'Patient Yearly Plan',
                'price': 599.00,
                'duration_days': 365,
                'description': 'Full access to patient portal with health tracking tools, appointment scheduling, and 24/7 support.',
                'is_active': True,
            }
        )
        
        if created:
            self.stdout.write(self.style.SUCCESS(f'✓ Created: {patient_plan.name}'))
        else:
            self.stdout.write(self.style.WARNING(f'Already exists: {patient_plan.name}'))
        
        self.stdout.write(self.style.SUCCESS('\n✓ Subscription plans setup complete!'))

