from django.core.mail import send_mail
from django.conf import settings
from django.template.loader import render_to_string
from django.utils.html import strip_tags
from django.contrib.sites.shortcuts import get_current_site
from django.urls import reverse


def send_password_reset_email(request, user, reset_token):
    """Send password reset email to user"""
    try:
        current_site = get_current_site(request)
        reset_url = request.build_absolute_uri(
            reverse('reset-password', kwargs={'token': reset_token.token})
        )
        
        context = {
            'user': user,
            'site_name': current_site.name,
            'reset_url': reset_url,
            'expiry_hours': 24,
        }
        
        html_message = render_to_string('emails/password_reset.html', context)
        plain_message = strip_tags(html_message)
        
        send_mail(
            subject='Password Reset Request - Tayapromediverse',
            message=plain_message,
            html_message=html_message,
            from_email=settings.DEFAULT_FROM_EMAIL,
            recipient_list=[user.email],
            fail_silently=False,
        )
        return True
    except Exception as e:
        print(f"Error sending password reset email: {e}")
        return False