from django.core.exceptions import ValidationError
import os

def validate_video_file_extension(value):
    """
    Validates that the uploaded file is a valid video format.
    Currently supports: mp4, webm, ogg
    """
    ext = os.path.splitext(value.name)[1]  # Get the extension
    valid_extensions = ['.mp4', '.webm', '.ogg']
    
    if not ext.lower() in valid_extensions:
        raise ValidationError('Unsupported file extension. Please upload MP4, WebM, or Ogg video files.')

def validate_video_file_size(value):
    """
    Validates that the uploaded video file is not too large.
    Limit: 1GB
    """
    filesize = value.size
    
    # 1GB in bytes = 1073741824
    if filesize > 1073741824:
        raise ValidationError('Video file size cannot exceed 1GB.')
