from django.core.management.base import BaseCommand
from users.models import DashboardCard


class Command(BaseCommand):
    help = 'Populate dashboard cards with existing data'

    def handle(self, *args, **options):
        self.stdout.write(self.style.SUCCESS('=== Populating Dashboard Cards ===\n'))
        
        # Delete existing cards if any
        existing_count = DashboardCard.objects.count()
        if existing_count > 0:
            self.stdout.write(f'Found {existing_count} existing cards. Deleting...')
            DashboardCard.objects.all().delete()
        
        # Dashboard items from the original views.py
        dashboard_items = [
            {"title": "Allergy and Immunology", "link": "https://tayapro.com/library/shop/category/allergy-and-immunology", "order": 1},
            {"title": "Alliance of Integrative and Indigenous Medicine (AIIM)", "link": "https://tayapro.com/library/shop/category/alliance-of-integrative-and-indigenous-medicine-aiim", "order": 2},
            {"title": "Audiobooks Hub", "link": "https://tayapro.com/library/shop/category/audiobooks-hub", "order": 3},
            {"title": "Beauty & Health", "link": "https://tayapro.com/library/shop/product/tayapro-beauty", "order": 4},
            {"title": "Building Wealth", "link": "https://tayapro.com/library/shop/category/building-wealth", "order": 5},
            {"title": "Cancer Therapeutics", "link": "https://tayapro.com/library/shop/category/cancer-therapeutics", "order": 6},
            {"title": "Cardiology", "link": "https://tayapro.com/library/shop/category/cardiology", "order": 7},
            {"title": "CHRONIC DISEASE PREVENTION AND MANAGEMENT (CDPM)", "link": "https://tayapro.com/library/shop/category/cdpm", "order": 8},
            {"title": "CHEETAA COUNTRIES AND CONSULTING", "link": "https://tayapro.com/library/shop/category/cheetaa-countries", "order": 9},
            {"title": "CULTURE AND PHILOSOPHY", "link": "https://tayapro.com/library/shop/category/world-philosophies-and-culture", "order": 10},
            {"title": "Digital Books - Portuguese", "link": "https://tayapro.com/library/shop/category/digital-books-portuguese", "order": 11},
            {"title": "DIGITAL BOOKS SECRETS SERIES", "link": "https://tayapro.com/library/shop/category/digital-books-secrets-series", "order": 12},
            {"title": "Digital Books in Russian", "link": "https://tayapro.com/library/shop/category/digital-books-in-russian", "order": 13},
        ]
        
        created_count = 0
        for item in dashboard_items:
            card = DashboardCard.objects.create(
                title=item['title'],
                link=item['link'],
                order=item['order'],
                is_active=True
            )
            created_count += 1
            self.stdout.write(f'  ✓ Created: {card.title}')
        
        self.stdout.write(self.style.SUCCESS(f'\n=== Created {created_count} dashboard cards ==='))
        self.stdout.write('\nYou can now manage dashboard cards through Django Admin!')
        self.stdout.write('Go to: http://127.0.0.1:8000/admin/users/dashboardcard/\n')

