# Toastify Notifications Implementation

This project now includes Toastify notifications across all templates. Here's how to use them:

## Templates with Toastify Support

All main templates now have Toastify notifications enabled:

- `base.html` - Base template with Toastify utilities
- `index.html` - Signup page with custom Toastify implementation
- `signin.html` - Login page with Toastify support
- `dashboard.html` - Dashboard with Toastify support
- `setting.html` - Settings page with Toastify support
- `profile.html` - Profile page (extends base.html)
- `security.html` - Security page (extends base.html)

## Django Messages Integration

Django messages are automatically converted to Toastify notifications:

```python
# In your Django views
from django.contrib import messages

messages.success(request, 'Profile updated successfully!')
messages.error(request, 'Password is incorrect.')
messages.warning(request, 'Please verify your email.')
messages.info(request, 'Welcome to Tayapro!')
```

## JavaScript Usage

### Using the Utility Functions

```javascript
// Show different types of notifications
ToastifyUtils.success("Operation completed successfully!");
ToastifyUtils.error("Something went wrong!");
ToastifyUtils.warning("Please check your input.");
ToastifyUtils.info("Information message");

// Or use the generic show method
ToastifyUtils.show("Custom message", "success");
ToastifyUtils.show("Error message", "error");
ToastifyUtils.show("Warning message", "warning");
ToastifyUtils.show("Info message", "info");
```

### Direct Toastify Usage

```javascript
// Direct Toastify usage (if you need custom options)
Toastify({
  text: "Custom notification",
  duration: 3000,
  gravity: "top",
  position: "right",
  backgroundColor: "linear-gradient(to right, #4facfe, #00f2fe)",
  stopOnFocus: true,
  onClick: function () {
    Toastify().hideToast();
  },
}).showToast();
```

## Color Scheme

The notifications use consistent gradient colors:

- **Success**: Blue gradient (`#4facfe` to `#00f2fe`)
- **Error**: Red gradient (`#ff416c` to `#ff4b2b`)
- **Warning**: Pink gradient (`#f093fb` to `#f5576c`)
- **Info**: Purple gradient (`#667eea` to `#764ba2`)

## Features

- **Auto-display**: Django messages are automatically shown when page loads
- **Click to dismiss**: Users can click on notifications to dismiss them
- **Consistent styling**: All notifications use the same color scheme and positioning
- **Responsive**: Notifications work on all device sizes
- **Accessible**: Notifications include proper ARIA attributes

## Files Modified

1. **`static/js/toastify-utils.js`** - Utility functions for consistent notifications
2. **`templates/base.html`** - Base template with Toastify integration
3. **`templates/index.html`** - Updated with consistent styling
4. **`templates/signin.html`** - Added Toastify support
5. **`templates/dashboard.html`** - Added Toastify support
6. **`templates/setting.html`** - Added Toastify support

All templates now support both Django messages and custom JavaScript notifications using Toastify.
