# TAYAPROMEDIVERSE Project

A Django web application for managing media content with user authentication, subscription plans, and a dynamic dashboard.

## Table of Contents

- [Project Overview](#project-overview)
- [Features](#features)
- [Prerequisites](#prerequisites)
- [Installation](#installation)
- [Running the Project](#running-the-project)
- [Development Environment](#development-environment)
- [Production Deployment](#production-deployment)
- [Project Structure](#project-structure)
- [User Management](#user-management)
- [Subscription Management](#subscription-management)
- [Dashboard Management](#dashboard-management)
- [Troubleshooting](#troubleshooting)

## Project Overview

TAYAPROMEDIVERSE is a Django-based web application that provides a platform for users to access media content through a subscription model. The application includes user authentication, profile management, subscription plans, and a dynamic dashboard for displaying content.

## Features

- User authentication and registration
- User profile management
- Email verification
- Password reset functionality
- Subscription plans and payment processing
- Dynamic dashboard with media content (images and videos)
- Responsive design for mobile and desktop

## Prerequisites

Before you begin, ensure you have the following installed:

- Python 3.9+ (recommended: Python 3.10)
- pip (Python package manager)
- virtualenv or venv (for creating virtual environments)
- Git (for version control)
- PostgreSQL (for production) or SQLite (for development)

## Installation

1. **Clone the repository:**

   ```bash
   git clone <repository-url>
   cd __pycache__  # Navigate to the project directory
   ```

2. **Create and activate a virtual environment:**

   ```bash
   # For Windows
   python -m venv venv
   venv\Scripts\activate

   # For macOS/Linux
   python3 -m venv venv
   source venv/bin/activate
   ```

3. **Install dependencies:**

   ```bash
   pip install -r requirements.txt
   ```

4. **Set up environment variables:**

   Create a `.env` file in the project root directory with the following variables:

   ```
   SECRET_KEY=your_secret_key
   DEBUG=True
   DATABASE_URL=sqlite:///db.sqlite3  # For development
   EMAIL_HOST=smtp.example.com
   EMAIL_PORT=587
   EMAIL_HOST_USER=your_email@example.com
   EMAIL_HOST_PASSWORD=your_email_password
   EMAIL_USE_TLS=True
   STRIPE_PUBLIC_KEY=your_stripe_public_key
   STRIPE_SECRET_KEY=your_stripe_secret_key
   ```

5. **Apply database migrations:**

   ```bash
   python manage.py migrate
   ```

6. **Create a superuser:**

   ```bash
   python manage.py createsuperuser
   ```

7. **Collect static files:**

   ```bash
   python manage.py collectstatic
   ```

## Running the Project

### Development Server

To run the development server:

```bash
python manage.py runserver
```

The application will be available at http://127.0.0.1:8000/

### Admin Interface

Access the admin interface at http://127.0.0.1:8000/admin/ using the superuser credentials created earlier.

## Development Environment

### Database Setup

By default, the project uses SQLite for development. To use PostgreSQL:

1. Install PostgreSQL and create a database
2. Update the `.env` file with your PostgreSQL connection details:

   ```
   DATABASE_URL=postgres://username:password@localhost:5432/database_name
   ```

### Running Tests

To run the test suite:

```bash
python manage.py test
```

### Working with Static Files

Static files are stored in the `static/` directory. After making changes to static files, run:

```bash
python manage.py collectstatic
```

## Production Deployment

### Server Requirements

- Ubuntu 20.04 LTS or newer
- Nginx
- Gunicorn
- PostgreSQL
- Python 3.9+

### Deployment Steps

1. **Set up the server:**

   ```bash
   chmod +x server_setup.sh
   ./server_setup.sh
   ```

2. **Configure Nginx:**

   ```bash
   sudo cp nginx.conf /etc/nginx/sites-available/tayapromediverse
   sudo ln -s /etc/nginx/sites-available/tayapromediverse /etc/nginx/sites-enabled/
   sudo nginx -t
   sudo systemctl restart nginx
   ```

3. **Configure Gunicorn:**

   ```bash
   sudo cp gunicorn.conf.py /etc/gunicorn/
   sudo cp django_app.conf /etc/systemd/system/
   sudo systemctl enable django_app
   sudo systemctl start django_app
   ```

4. **Deploy the application:**

   ```bash
   chmod +x deploy.sh
   ./deploy.sh
   ```

### SSL Configuration

To secure your site with SSL:

```bash
sudo apt install certbot python3-certbot-nginx
sudo certbot --nginx -d tayapromediverse.org -d www.tayapromediverse.org
```

## Project Structure

```
__pycache__/
├── conn_prjct/           # Django project settings
├── media/                # User uploaded files
├── static/               # Static files (CSS, JS, images)
├── staticfiles/          # Collected static files
├── templates/            # HTML templates
├── users/                # User management app
├── manage.py             # Django management script
├── requirements.txt      # Python dependencies
└── README.md             # This file
```

## User Management

The project uses Django's built-in authentication system extended with custom user profiles.

### User Types

- **Regular User**: Basic access to content
- **Premium User**: Full access to all content
- **Administrator**: Full access with management capabilities

### Authentication

The project uses Django AllAuth for authentication, providing:

- Email verification
- Password reset
- Social authentication (if configured)

## Subscription Management

### Subscription Plans

Manage subscription plans through the admin interface at `/admin/users/subscriptionplan/`.

### Payment Processing

The project uses Stripe for payment processing. Configure your Stripe API keys in the `.env` file.

## Dashboard Management

### Adding Content

1. Log in to the admin interface
2. Navigate to "Dashboard Cards"
3. Click "Add Dashboard Card"
4. Fill in the details:
   - Title
   - Description
   - Upload an image or provide an image URL
   - Upload a video or provide a video URL (optional)
   - External link (optional)
   - Order (for sorting)
   - Active status

### Managing Content

From the admin interface, you can:
- Edit existing content
- Change the display order
- Activate/deactivate content
- Delete content

## Troubleshooting

For common issues and solutions, refer to the `TROUBLESHOOTING_FIXED.md` file in the project root.

### Common Issues

1. **Static files not loading:**
   - Run `python manage.py collectstatic`
   - Check Nginx configuration

2. **Database migration errors:**
   - Try `python manage.py makemigrations` followed by `python manage.py migrate`

3. **Email sending issues:**
   - Verify SMTP settings in the `.env` file
   - Check server firewall settings

4. **Payment processing errors:**
   - Verify Stripe API keys
   - Check Stripe webhook configuration

For additional help, please contact the development team at tayaprolibrary@gmail.com.
