#!/usr/bin/env python
"""
Email Configuration Test Script
Run this to test your email settings
"""

import os
import sys
import django

# Add the project directory to Python path
sys.path.append('/Users/usman/Downloads/cnn prjct/conn_prjct')

# Set up Django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'conn_prjct.settings')
django.setup()

from django.core.mail import send_mail
from django.conf import settings

def test_email():
    try:
        # Test email sending
        send_mail(
            'Test Email from TAYAPROMEDIVERSE',
            'This is a test email to verify your email configuration is working correctly.',
            settings.DEFAULT_FROM_EMAIL,
            ['your-test-email@gmail.com'],  # Replace with your test email
            fail_silently=False,
        )
        print("✅ Email sent successfully!")
        print(f"From: {settings.DEFAULT_FROM_EMAIL}")
        print(f"SMTP Host: {settings.EMAIL_HOST}")
        print(f"SMTP Port: {settings.EMAIL_PORT}")
        print(f"TLS Enabled: {settings.EMAIL_USE_TLS}")
    except Exception as e:
        print(f"❌ Email failed to send: {e}")
        print("\nTroubleshooting:")
        print("1. Check your EMAIL_HOST_USER and EMAIL_HOST_PASSWORD")
        print("2. For Gmail, make sure you're using an App Password, not your regular password")
        print("3. Ensure 2-Factor Authentication is enabled on your Gmail account")
        print("4. Check if your email provider requires specific SMTP settings")

if __name__ == "__main__":
    test_email()
