// Toastify Utility Functions for Django Project
// This file provides consistent toast notifications across all templates

window.ToastifyUtils = {
  // Show a toast notification with consistent styling
  show: function(message, type = 'info') {
    const colors = {
      'success': 'linear-gradient(to right, #4facfe, #00f2fe)',
      'error': 'linear-gradient(to right, #ff416c, #ff4b2b)',
      'warning': 'linear-gradient(to right, #f093fb, #f5576c)',
      'info': 'linear-gradient(to right, #667eea, #764ba2)'
    };

    Toastify({
      text: message,
      duration: 5000,
      gravity: "top",
      position: "right",
      backgroundColor: colors[type] || colors['info'],
      stopOnFocus: true,
      onClick: function() {
        Toastify().hideToast();
      }
    }).showToast();
  },

  // Show success message
  success: function(message) {
    this.show(message, 'success');
  },

  // Show error message
  error: function(message) {
    this.show(message, 'error');
  },

  // Show warning message
  warning: function(message) {
    this.show(message, 'warning');
  },

  // Show info message
  info: function(message) {
    this.show(message, 'info');
  }
};

// Auto-display Django messages when page loads
document.addEventListener('DOMContentLoaded', function() {
  // Check for Django messages in hidden div
  const messageContainer = document.getElementById('django-messages');
  if (messageContainer) {
    const messages = messageContainer.querySelectorAll('div[data-type][data-message]');
    messages.forEach(function(msgDiv) {
      const type = msgDiv.getAttribute('data-type') || 'info';
      const message = msgDiv.getAttribute('data-message');
      if (message) {
        ToastifyUtils.show(message, type);
      }
    });
  }
});
